#! /usr/bin/perl
####################################################
# Spiform log file to csv file  Ver.1.0 2001-05-29 #
#        Takashi Kosuge                            #
####################################################
use strict;
use constant INIFILE => 'spiform.ini';
use constant SEPARATOR => '\s+';
use XML::Parser;
use Jcode;
use Symbol;

$|=1;
#----- Setup and checking files ----------------------
my %var;              #Settings;
my $logfile;
my $inputfile;
my $outputfile;
my $vkeys;            #Keywords in Form (space)
my @vkeys;            #Keywords in Form (list)
my $buf;
my $category;
while($_=shift(@ARGV)){
	if(/^-L(\S+)/){
		$logfile = $1;
	}elsif(/^-O(\S+)/){
		$outputfile = $1;
	}elsif(/^-h$/i){
		die "Usage: $0 FormFile\n";
	}else{
		$inputfile = $_;
	}
}
unless($inputfile){
	print "Please enter form file name: ";
	$_=<STDIN>;
	chomp;
	unless($_){die;}
	$inputfile=$_;
}
unless($logfile){
	%var = get_setting(SEPARATOR,INIFILE);
	unless($logfile = $var{':Log_File'}){die ":Log_File is not found.\n";}
}
unless($outputfile){
	$outputfile = $inputfile;
	$outputfile =~ s/\..+$//;
	$outputfile .= '.csv';
}

#---- Read form file and set keys ---------------------
open(BUF1, $inputfile) or die "Form file: $!\n";
# Skip lines until FORM tag will be found.
while(1){
	unless($_ = <BUF1>){die "FORM tag not found\n";}
	if(/<\s*FORM /i){last;}
}
# Set keys
while(<BUF1>){
	while(s/ NAME\s*=\s*\"([A-Za-z0-9_-]+)\"//i){
		$buf=$1;
		if($buf eq 'Category'){
			while(1){
				if(/ Value\s*=\s*\"([A-Za-z0-9_-]+)\"/i){
					$category=$1;
					last;
				}
				unless($_ = <BUF1>){die "Category value not found\n";}
			}
			next;
		}
		unless($vkeys =~ / $buf( |$)/){
			$vkeys .= " $buf";
		}
	}
}
close(BUF1);
$vkeys =~ s/^ //;
@vkeys = split(' ', $vkeys);

#-------------- Parse XML and write to csv file ------------------------
my $xml;
my $flg;
my $outbuf;
my $lp;
%::XVar=();   # XML variables
$::el='';     # XML element level
$::p = new XML::Parser(Handlers => {Start => \&handle_start,
				Char => \&handle_char,
				End => \&handle_end});

if(-e $outputfile){
	yesNo("$outputfile already exists. Overwrite?") or die "Terminated\n";
}

open(BUF1, $logfile) or die "Logfile: $!\n";
open(BUF2, ">$outputfile");
binmode(BUF2);

print 'Parsing ';

#print Header
$outbuf = "\"ID\",\"Date\"";
foreach $lp (@vkeys){
	if($lp eq 'ID' or $lp eq 'Category' or $lp eq 'Date'
	   or $lp eq 'Subject' or $lp eq 'Success'){next;}
	$outbuf .= ",\"$lp\"";
}
print BUF2 "$outbuf\r\n";

while(1){
	$xml='<?xml version="1.0" encoding="utf-8"?>';
	$::el='';
	%::XVar='';
	$flg=0;
	while(<BUF1>){
		s/\r//;
		$buf=$_;
		$xml .= $_;
		if($buf =~ /^<\/Submission>/){
			$flg=1;
			last;
		}
	}
	unless($flg){last;}
	$xml=Jcode->new($xml,'euc')->utf8;
	eval('$::p->parse($xml)');
	if($@){
		print "Error: $@\n";
		print Jcode->new($xml,'utf8')->sjis."\n";
		die;
	}
	if($::XVar{':Submission.Category'} ne $category){
		print '.';
		next;
	}
print 'o';

	$outbuf = "\"".$::XVar{':Submission.ID'}."\",\""
		. $::XVar{':Submission.Date'} . "\"";
	foreach $lp (@vkeys){
		if($lp eq 'ID' or $lp eq 'Category' or $lp eq 'Date'
		   or $lp eq 'Subject' or $lp eq 'Success'){next;}
		if(defined $::XVar{":Submission:$lp.Value"}){
			$outbuf .= ",\"".$::XVar{":Submission:$lp.Value"}."\"";
		}else{
			$outbuf .= ",\"\"";
		}
	}
	print BUF2 Jcode->new($outbuf,'utf8')->sjis."\r\n";
}

close(BUF2);
close(BUF1);

print " Done\n";


exit;

sub get_setting{
	my $separator = shift(@_);
	my $filename  = shift(@_);
	my $lp;
	my %var;
	my $buf;
	my $fh=gensym();
	open($fh, $filename) or return(undef);
	while(<$fh>){
		if(/^#/){next;}
		chomp;s/\r//;
		if($_ eq ''){next;}
		unless(/\s*(\S+)$separator(.*)/){next;}
		$var{$1}=$2;
	}
	close($fh);
	return(%var);
}

sub yesNo{
    my $buff=shift;
    my $b;
    print "$buff Y/[N]: ";
    $b=<STDIN>;chomp($b);
    if($b eq 'Y' or $b eq 'y'){return(1);}else{return(0);}
}

sub handle_start{
	my ($xx,$element,@in) = @_;
	my $k;
	my $v;
	
	$::el .= ":$element";
	while(1){
		unless($k = shift(@in)){last;}
		$v=shift(@in);
		$::XVar{"$::el.$k"}=$v;
	}
}

sub handle_char{
	my ($xx,$text) = @_;
	$::XVar{"$::el.Value"} .= $text;
}

sub handle_end{
	my ($xx,$element) = @_;
	$::el =~ s/:$element$//;
}

