#! /usr/bin/perl
################################
##  Spiform setup program
##  Takashi Kosuge
##  $Revision: 1.8 $
##  $Date: 2006/07/25 07:07:35 $
################################
use strict;
use constant INIFILE => (shift(@ARGV) or 'spiform.ini');
use constant CABINET => 'spiform.org';
$::Var=();
my $c;

$|=1;
#Main Loop============================
while(1){
	print "=== Setup spiform: i = install, s = show config, q = quit ===\n> ";
	$c = <STDIN>;
	chomp($c);
	if($c eq 'q'){
		last;
	}elsif($c eq 's'){
		show_config();
	}elsif($c eq 'i'){
		install();
	}
}
exit;

sub install{
	load_config();
	unless(check_config()){return;}
	unless(
  yesNo("Wold you like to install spiform to \"".$::Var{':Install_Dir'}."\" ?")
	){return;}
	my $inbuf ='';

#install main program
print "Writing spiform...";
	unless(open(BUF1, CABINET)){
		print "Error: Could not found \"".CABINET."\".\n";
		return;
	}
	while(<BUF1>){
		chomp; s/\r//;
		$inbuf .= "$_\n";
	}
	close(BUF1);

	my $i;
	my @categories=();
	my $catbuf;
	foreach $i (keys(%::Var)){
		unless($i =~ /^:/){
			$catbuf = "'$i' => '" . $::Var{$i} . "'";
			push(@categories, $catbuf);
		}else{
			$inbuf =~ s/<<$i>>/$::Var{$i}/g;
		}
	}
	unless($::Var{':Local_Host'}){
		$inbuf =~ s/<<:Local_Host>>//g;
	}
	$::Var{':Save_Log'} =~ s/,/ /g;
	$inbuf =~ s/<<Save_Log>>/$::Var{':Save_Log'}/g;
	$catbuf = join(",\n", @categories);
	$inbuf =~ s/<<Categories>>/$catbuf/;

	unless(open(BUF1, ">".$::Var{':Install_Dir'}."/".$::Var{':CGI_Name'})){
		print "Error: $!\n";
		return;
	}
	print BUF1 $inbuf;
	close(BUF1);
print " Done\n";

#make logfile
	unless($::Var{':Log_File'} =~ /^([A-Za-z]:\/|\/)/){
		$::Var{':Log_File'} = $::Var{':Install_Dir'}.$::Var{':Log_File'};
	}
print "Creating log file...";
	if(-e $::Var{':Log_File'}){
		print " Log file already exists. Aborted.\n";
	}else{
		unless(open(BUF1, ">".$::Var{':Log_File'})){
			print "Error: $!\n";
		}else{
			close(BUF1);
print " Done\n";
		}
	}
}

sub check_config{
	my @rq = qw(:Install_Dir :CGI_Name :SMTP_Server :Sender_Email :Log_File
		:Program_ID :Lock_ID :Lock_Dir);
	my $i;
	foreach $i (@rq){
		unless($::Var{$i}){
			print "Error: $i is void.\n";
			return(0);
		}
	}
	return(1);
}

sub show_config{
	my $i;
	my @vkeys;
	@vkeys = load_config();
	foreach $i (@vkeys){
		print "$i\t".$::Var{$i}."\n";
	}
}

sub load_config{
	my($key, $var);
	my @vkeys=();
	open(BUF, INIFILE) or die;
	$::Var=();
	while(<BUF>){
		chomp;
		s/\r//;
		if($_ eq ''){next;}
		if(/^#/){next;}
		s/^\s+//;
		s/\s+$//;
		($key, $var) = split(/\s+/,$_);
		if($key eq ''){next;}
		unless($var){
			$::Var{$key}='';
		}else{
			$::Var{$key}=$var;
		}
		if($key =~ /_Dir$/){
			unless($::Var{$key} =~ /\/$/){
				$::Var{$key} .= '/';
			}
		}
		push(@vkeys,$key);
	}
	close(BUF);
	return(@vkeys);
}

sub Yesno{
    my $buff=shift;
    my $b;
    print "$buff [Y]/N: ";
    $b=<STDIN>;chomp($b);
    if($b eq 'N' or $b eq 'n'){return(0);}else{return(1);}
}

sub yesNo{
    my $buff=shift;
    my $b;
    print "$buff Y/[N]: ";
    $b=<STDIN>;chomp($b);
    if($b eq 'Y' or $b eq 'y'){return(1);}else{return(0);}
}
